// SCH Course Copyright Policy (C): DO-NOT-SHARE-WITH-ANYONE
// https://smartcontractshacking.com/#copyright-policy
pragma solidity ^0.8.13;

import "@openzeppelin/contracts/token/ERC20/ERC20.sol";
import "@openzeppelin/contracts/access/Ownable.sol";

/**
 * @title DummyERC20
 * @author JohnnyTime (https://smartcontractshacking.com)
 */
contract DummyERC20 is ERC20, Ownable {

    uint256 public currentSupply = 0;
    
    constructor(string memory _name, string memory _symbol, uint256 _initialSupply)
     ERC20(_name, _symbol) {
        _mint(owner(), _initialSupply);
     }

    function mint(address _to, uint256 _amount) public onlyOwner {
        _mint(_to, _amount);
    }
}